SET NAMES utf8;
SET foreign_key_checks = 0;
SET time_zone = 'SYSTEM';
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `contacts`;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_user` int(10) unsigned NOT NULL,
  `id_user_contact` int(10) unsigned NOT NULL,
  `alias` varchar(255) collate utf8_slovak_ci default NULL,
  `time_added` datetime default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `user__contact` (`id_user`,`id_user_contact`),
  KEY `contacts_FKIndex1` (`id_user`),
  KEY `contacts_FKIndex2` (`id_user_contact`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `file_transfers`;
CREATE TABLE `file_transfers` (
  `id` int(11) NOT NULL auto_increment,
  `id_user` int(11) NOT NULL,
  `id_user_contact` int(11) NOT NULL,
  `name` text collate utf8_slovak_ci,
  `path` text collate utf8_slovak_ci,
  `size` int(10) unsigned default NULL,
  `sent_time` datetime default NULL,
  `recieved_time` datetime default NULL,
  `refused_time` datetime default NULL,
  PRIMARY KEY  (`id`,`id_user`,`id_user_contact`),
  KEY `posts_FKIndex1` (`id_user`),
  KEY `posts_FKIndex2` (`id_user_contact`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `file_transfers_history`;
CREATE TABLE `file_transfers_history` (
  `id` int(11) NOT NULL auto_increment,
  `id_user` int(11) NOT NULL,
  `id_user_contact` int(11) NOT NULL,
  `name` text collate utf8_slovak_ci,
  `path` text collate utf8_slovak_ci,
  `size` int(10) unsigned default NULL,
  `sent_time` datetime default NULL,
  `recieved_time` datetime default NULL,
  `refused_time` datetime default NULL,
  PRIMARY KEY  (`id`,`id_user`,`id_user_contact`),
  KEY `posts_FKIndex1` (`id_user`),
  KEY `posts_FKIndex2` (`id_user_contact`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_user` int(10) unsigned NOT NULL,
  `id_user_contact` int(10) unsigned NOT NULL,
  `text` text collate utf8_slovak_ci,
  `sent_time` datetime default NULL,
  `recieved_time` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `posts_FKIndex1` (`id_user`),
  KEY `posts_FKIndex2` (`id_user_contact`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `posts_history`;
CREATE TABLE `posts_history` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_user` int(10) unsigned NOT NULL,
  `id_user_contact` int(10) unsigned NOT NULL,
  `text` text collate utf8_slovak_ci,
  `sent_time` datetime default NULL,
  `recieved_time` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `posts_history_FKIndex1` (`id_user`),
  KEY `posts_history_FKIndex2` (`id_user_contact`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `registrations`;
CREATE TABLE `registrations` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_user` int(10) unsigned NOT NULL default '0',
  `nick` varchar(100) collate utf8_slovak_ci default NULL,
  `login` varchar(128) collate utf8_slovak_ci default NULL,
  `pass` varchar(128) collate utf8_slovak_ci default NULL,
  `email` varchar(255) collate utf8_slovak_ci default NULL,
  `time` datetime default NULL,
  `regkey` varchar(128) collate utf8_slovak_ci default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nick` (`nick`),
  KEY `regkey` (`regkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_user` int(10) unsigned NOT NULL,
  `ip` varchar(128) collate utf8_slovak_ci default NULL,
  `sid` varchar(255) collate utf8_slovak_ci default NULL,
  `last_action_time` datetime default NULL,
  `logout_time` datetime default NULL,
  `logout_reason` enum('manual','timeout') collate utf8_slovak_ci default NULL,
  PRIMARY KEY  (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;


DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `nick` varchar(100) collate utf8_slovak_ci default NULL,
  `login` varchar(128) collate utf8_slovak_ci default NULL,
  `pass` varchar(128) collate utf8_slovak_ci default NULL,
  `email` varchar(255) collate utf8_slovak_ci default NULL,
  `active` tinyint(1) default NULL,
  `web` varchar(255) collate utf8_slovak_ci default NULL,
  `phone` varchar(30) collate utf8_slovak_ci default NULL,
  `name` varchar(50) collate utf8_slovak_ci default NULL,
  `surname` varchar(50) collate utf8_slovak_ci default NULL,
  `address` varchar(255) collate utf8_slovak_ci default NULL,
  `profile` text collate utf8_slovak_ci,
  `anonymous` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `login_pass` (`nick`,`pass`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_slovak_ci;

